<?php
// Konfigurasi database
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'kmgstore';

// Membuat koneksi ke database
$conn = new mysqli($host, $username, $password, $database);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Set charset untuk menghindari masalah encoding
$conn->set_charset("utf8");

$message = '';
$message_type = '';

// Proses form ketika di-submit
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nama_game = $conn->real_escape_string($_POST['nama_game']);
    $item_jenis = $conn->real_escape_string($_POST['item_jenis']);
    $nominal = $conn->real_escape_string($_POST['nominal']);
    $total_bayar = $conn->real_escape_string($_POST['total_bayar']);
    
    // Validasi input
    if (empty($nama_game) || empty($item_jenis) || empty($nominal) || empty($total_bayar)) {
        $message = "Semua field harus diisi!";
        $message_type = "error";
    } elseif (!is_numeric($total_bayar)) {
        $message = "Total bayar harus berupa angka!";
        $message_type = "error";
    } else {
        // Insert data ke database
        $sql = "INSERT INTO produk (product_nama_game, product_item_jenis, product_nominal, product_total_bayar) 
                VALUES ('$nama_game', '$item_jenis', '$nominal', '$total_bayar')";
        
        if ($conn->query($sql) === TRUE) {
            $message = "Produk berhasil ditambahkan!";
            $message_type = "success";
            
            // Redirect ke halaman product list setelah 2 detik
            echo "<script>
                    setTimeout(function() {
                        window.location.href = 'productlist.php';
                    }, 2000);
                  </script>";
        } else {
            $message = "Error: " . $sql . "<br>" . $conn->error;
            $message_type = "error";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Produk - KMGSTORE</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        
        :root {
            --primary-color: #2563eb;
            --primary-dark: #1d4ed8;
            --success-color: #16a34a;
            --success-dark: #15803d;
            --warning-color: #f59e0b;
            --warning-dark: #d97706;
            --danger-color: #dc2626;
            --danger-dark: #b91c1c;
            --bg-color: #f8fafc;
            --border-color: #e5e7eb;
            --text-color: #374151;
            --text-muted: #6b7280;
            --sidebar-width: 250px;
            --border-radius: 12px;
            --box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--bg-color);
            color: var(--text-color);
            line-height: 1.6;
        }

        /* Sidebar Styles */
        .sidebar {
            width: var(--sidebar-width);
            position: fixed;
            height: 100vh;
            background-color: #ffffff;
            border-right: 1px solid var(--border-color);
            padding: 2rem 1.5rem;
            box-shadow: var(--box-shadow);
            z-index: 1000;
        }

        .sidebar .logo {
            margin-bottom: 2rem;
            text-align: center;
            border-bottom: 1px solid var(--border-color);
            padding-bottom: 1rem;
        }

        .sidebar .logo h4 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .sidebar .logo small {
            color: var(--text-muted);
            font-size: 0.875rem;
        }

        .sidebar .nav-link {
            color: var(--text-color);
            padding: 0.875rem 1rem;
            margin-bottom: 0.5rem;
            border-radius: 8px;
            text-decoration: none;
            display: flex;
            align-items: center;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .sidebar .nav-link:hover {
            background-color: #f0f9ff;
            color: var(--primary-color);
            transform: translateX(4px);
        }

        .sidebar .nav-link.active {
            background-color: var(--primary-color);
            color: white;
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.3);
        }

        .sidebar .nav-link i {
            margin-right: 0.75rem;
            width: 18px;
            text-align: center;
        }

        .sidebar hr {
            border: 0;
            border-top: 1px solid var(--border-color);
            margin: 1.5rem 0;
        }

        .sidebar .nav-link.text-danger:hover {
            background-color: #fef2f2;
            color: var(--danger-color);
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            padding: 2rem;
            min-height: 100vh;
        }

        .content-header {
            background: white;
            padding: 2rem;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-bottom: 2rem;
        }

        .content-header h1 {
            color: var(--text-color);
            margin: 0;
            font-size: 2rem;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
            color: #333;
        }

        input[type="text"],
        input[type="number"],
        select {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            box-sizing: border-box;
            transition: border-color 0.3s ease;
        }

        input[type="text"]:focus,
        input[type="number"]:focus,
        select:focus {
            outline: none;
            border-color: #2563eb;
            box-shadow: 0 0 5px rgba(37, 99, 235, 0.3);
        }

        .btn {
            padding: 12px 24px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            text-decoration: none;
            display: inline-block;
            margin-right: 10px;
            transition: all 0.3s ease;
            font-weight: 500;
        }

        .btn-primary {
            background-color: #2563eb;
            color: white;
        }

        .btn-primary:hover {
            background-color: #1d4ed8;
        }

        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }

        .btn-secondary:hover {
            background-color: #5a6268;
        }

        .form-actions {
            text-align: center;
            margin-top: 30px;
        }

        .message {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 8px;
            text-align: center;
            font-weight: 500;
        }

        .message.success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .message.error {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .back-link {
            display: inline-flex;
            align-items: center;
            margin-bottom: 20px;
            color: #2563eb;
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }

        .back-link:hover {
            color: #1d4ed8;
        }

        .back-link i {
            margin-right: 8px;
        }

        .currency-input {
            position: relative;
        }

        .currency-prefix {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            color: #666;
            font-weight: bold;
        }

        .currency-input input {
            padding-left: 35px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s ease;
            }

            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="logo">
            <h4><i class="fas fa-store"></i> KMG Store</h4>
            <small>Admin Panel</small>
        </div>

        <nav class="nav flex-column">
            <a class="nav-link" href="admin-dashboard.php">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>
            <a class="nav-link" href="transaksi.php">
                <i class="fas fa-shopping-cart"></i> Transaksi
            </a>
            <a class="nav-link" href="pengguna.php">
                <i class="fas fa-users"></i> Pengguna
            </a>
            <a class="nav-link" href="productlist.php">
                <i class="fas fa-boxes"></i> Product List
            </a>
            <a class="nav-link active" href="add_product.php">
                <i class="fas fa-plus-circle"></i> Tambah Produk
            </a>
            
            <hr>
            
            <a class="nav-link text-danger" href="logout.php">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Content Header -->
        <div class="content-header">
            <h1>
                <i class="fas fa-plus-circle" style="color: var(--primary-color);"></i>
                Tambah Produk Baru
            </h1>
        </div>

        <div class="container">
            <a href="productlist.php" class="back-link">
                <i class="fas fa-arrow-left"></i> Kembali ke Daftar Produk
            </a>
            
            <?php if (!empty($message)): ?>
                <div class="message <?php echo $message_type; ?>">
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="" id="productForm">
                <div class="form-group">
                    <label for="nama_game">Nama Game *</label>
                    <input type="text" id="nama_game" name="nama_game" 
                           placeholder="Contoh: Mobile Legends, Free Fire, PUBG Mobile" 
                           required>
                </div>
                
                <div class="form-group">
                    <label for="item_jenis">Jenis Item *</label>
                    <input type="text" id="item_jenis" name="item_jenis" 
                           placeholder="Contoh: Diamond, UC, Voucher" 
                           required>
                </div>
                
                <div class="form-group">
                    <label for="nominal">Nominal *</label>
                    <input type="text" id="nominal" name="nominal" 
                           placeholder="Contoh: 100 Diamond, 300 UC, 50000 Coins" 
                           required>
                </div>
                
                <div class="form-group">
                    <label for="total_bayar">Total Bayar (Rp) *</label>
                    <div class="currency-input">
                        <span class="currency-prefix">Rp</span>
                        <input type="number" id="total_bayar" name="total_bayar" 
                               placeholder="0" 
                               min="0" 
                               step="1000" 
                               required>
                    </div>
                </div>
                
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save" style="margin-right: 8px;"></i>Tambah Produk
                    </button>
                    <a href="productlist.php" class="btn btn-secondary">
                        <i class="fas fa-times" style="margin-right: 8px;"></i>Batal
                    </a>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        // Format angka dengan separator ribuan
        document.getElementById('total_bayar').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            if (value) {
                e.target.value = value;
            }
        });

        // Validasi form sebelum submit
        document.getElementById('productForm').addEventListener('submit', function(e) {
            const namaGame = document.getElementById('nama_game').value.trim();
            const itemJenis = document.getElementById('item_jenis').value.trim();
            const nominal = document.getElementById('nominal').value.trim();
            const totalBayar = document.getElementById('total_bayar').value.trim();
            
            if (!namaGame || !itemJenis || !nominal || !totalBayar) {
                alert('Semua field harus diisi!');
                e.preventDefault();
                return false;
            }
            
            if (isNaN(totalBayar) || totalBayar <= 0) {
                alert('Total bayar harus berupa angka yang valid!');
                e.preventDefault();
                return false;
            }
            
            // Konfirmasi sebelum submit
            if (!confirm('Apakah Anda yakin ingin menambahkan produk ini?')) {
                e.preventDefault();
                return false;
            }
        });
    </script>
</body>
</html>

<?php
// Tutup koneksi database
$conn->close();
?>