<?php
// Konfigurasi database
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'kmgstore';

// Membuat koneksi ke database
$conn = new mysqli($host, $username, $password, $database);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Set charset untuk menghindari masalah encoding
$conn->set_charset("utf8");

// Inisialisasi variabel
$error_message = "";
$success_message = "";
$product_data = null;

// Cek apakah ada ID produk yang dikirim
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: productlist.php");
    exit();
}

$product_id = (int)$_GET['id'];

// Ambil data produk berdasarkan ID untuk ditampilkan
$sql_select = "SELECT * FROM produk WHERE product_id = ?";
$stmt_select = $conn->prepare($sql_select);
$stmt_select->bind_param("i", $product_id);
$stmt_select->execute();
$result = $stmt_select->get_result();

if ($result->num_rows == 0) {
    header("Location: productlist.php");
    exit();
}

$product_data = $result->fetch_assoc();
$stmt_select->close();

// Proses penghapusan ketika dikonfirmasi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['confirm_delete'])) {
    // Hapus produk dari database
    $sql_delete = "DELETE FROM produk WHERE product_id = ?";
    $stmt_delete = $conn->prepare($sql_delete);
    $stmt_delete->bind_param("i", $product_id);
    
    if ($stmt_delete->execute()) {
        $stmt_delete->close();
        // Redirect ke productlist.php dengan pesan sukses
        header("Location: productlist.php?deleted=1");
        exit();
    } else {
        $error_message = "Gagal menghapus produk: " . $conn->error;
    }
    
    $stmt_delete->close();
}

// Jika user membatalkan penghapusan
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['cancel_delete'])) {
    header("Location: productlist.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hapus Produk - KMGSTORE</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #d32f2f;
            text-align: center;
            margin-bottom: 30px;
        }
        .warning-box {
            background-color: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 4px;
            padding: 20px;
            margin-bottom: 30px;
            text-align: center;
        }
        .warning-icon {
            font-size: 48px;
            color: #f39c12;
            margin-bottom: 15px;
        }
        .warning-text {
            font-size: 18px;
            font-weight: bold;
            color: #8a6d3b;
            margin-bottom: 10px;
        }
        .warning-subtext {
            color: #8a6d3b;
            margin-bottom: 20px;
        }
        .product-details {
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 4px;
            padding: 20px;
            margin-bottom: 30px;
        }
        .product-details h3 {
            margin-top: 0;
            color: #333;
            border-bottom: 2px solid #4CAF50;
            padding-bottom: 10px;
        }
        .detail-row {
            display: flex;
            margin-bottom: 10px;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .detail-row:last-child {
            border-bottom: none;
        }
        .detail-label {
            font-weight: bold;
            width: 120px;
            color: #555;
        }
        .detail-value {
            flex: 1;
            color: #333;
        }
        .currency {
            font-weight: bold;
            color: #2e7d32;
        }
        .btn {
            padding: 12px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            text-decoration: none;
            font-size: 14px;
            display: inline-block;
            text-align: center;
            margin-right: 10px;
            font-weight: bold;
        }
        .btn-danger {
            background-color: #f44336;
            color: white;
        }
        .btn-danger:hover {
            background-color: #d32f2f;
        }
        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
        }
        .form-actions {
            text-align: center;
            margin-top: 30px;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .alert-error {
            color: #721c24;
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
        }
        .delete-confirmation {
            background-color: #ffebee;
            border: 2px solid #f44336;
            border-radius: 4px;
            padding: 20px;
            margin-bottom: 20px;
        }
        .delete-confirmation h4 {
            color: #f44336;
            margin-top: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🗑️ Hapus Produk</h1>
        
        <!-- Pesan error jika ada -->
        <?php if (!empty($error_message)): ?>
            <div class="alert alert-error">
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>
        
        <!-- Peringatan -->
        <div class="warning-box">
            <div class="warning-icon">⚠️</div>
            <div class="warning-text">PERINGATAN!</div>
            <div class="warning-subtext">
                Anda akan menghapus produk ini secara permanen.<br>
                Tindakan ini tidak dapat dibatalkan.
            </div>
        </div>
        
        <!-- Detail produk yang akan dihapus -->
        <div class="product-details">
            <h3>Detail Produk yang akan dihapus:</h3>
            <div class="detail-row">
                <div class="detail-label">ID Produk:</div>
                <div class="detail-value"><?php echo $product_data['product_id']; ?></div>
            </div>
            <div class="detail-row">
                <div class="detail-label">Nama Game:</div>
                <div class="detail-value"><?php echo htmlspecialchars($product_data['product_nama_game']); ?></div>
            </div>
            <div class="detail-row">
                <div class="detail-label">Jenis Item:</div>
                <div class="detail-value"><?php echo htmlspecialchars($product_data['product_item_jenis']); ?></div>
            </div>
            <div class="detail-row">
                <div class="detail-label">Nominal:</div>
                <div class="detail-value"><?php echo htmlspecialchars($product_data['product_nominal']); ?></div>
            </div>
            <div class="detail-row">
                <div class="detail-label">Total Bayar:</div>
                <div class="detail-value currency">
                    Rp <?php echo number_format($product_data['product_total_bayar'], 0, ',', '.'); ?>
                </div>
            </div>
        </div>
        
        <!-- Konfirmasi penghapusan -->
        <div class="delete-confirmation">
            <h4>Konfirmasi Penghapusan</h4>
            <p>Apakah Anda yakin ingin menghapus produk "<strong><?php echo htmlspecialchars($product_data['product_nama_game']); ?></strong>" ini?</p>
            <p><strong>Tindakan ini tidak dapat dibatalkan!</strong></p>
        </div>
        
        <!-- Form konfirmasi -->
        <form method="POST" action="">
            <div class="form-actions">
                <button type="submit" name="confirm_delete" class="btn btn-danger" onclick="return confirmDelete()">
                    🗑️ Ya, Hapus Produk
                </button>
                <button type="submit" name="cancel_delete" class="btn btn-secondary">
                    ← Batal
                </button>
            </div>
        </form>
    </div>

    <script>
        function confirmDelete() {
            return confirm('Apakah Anda benar-benar yakin ingin menghapus produk ini?\n\nTindakan ini tidak dapat dibatalkan!');
        }
        
        // Auto focus pada tombol batal untuk keamanan
        document.addEventListener('DOMContentLoaded', function() {
            // Fokus pada tombol batal sebagai default untuk mencegah penghapusan yang tidak disengaja
            document.querySelector('button[name="cancel_delete"]').focus();
        });
    </script>
</body>
</html>

<?php
// Tutup koneksi database
$conn->close();
?>