<?php

session_start();
include_once("config.php");
include_once("functions.php");

cek_login_user();
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Pilih Game - KMGSTORE</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    body {
      margin: 0;
      font-family: Arial, sans-serif;
      background: #1e1e1e;
      color: #fff;
    }
    .navbar {
      position: relative;
      background: #1e2635;
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px 20px;
      z-index: 5;
      backdrop-filter: blur(10px);
    }
    .game-card {
      background: rgba(42, 42, 42, 0.8);
      border-radius: 10px;
      overflow: hidden;
      transition: all 0.3s ease;
    }
    .game-card:hover {
      transform: translateY(-5px);
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
    }
    .game-img {
      width: 100%;
      height: 200px;
      object-fit: cover;
    }
    .footer-bottom {
      background-color: #1e2635;
      color: white;
      padding: 20px;
      text-align: center;
      font-size: 13px;
      margin-top: 40px;
    }
  </style>
</head>
<body>

  <nav class="navbar">
    <div class="text-lg font-bold tracking-wide">
      KMG<span class="text-white">STORE</span>
    </div>
    <div class="flex items-center space-x-2">
      <?php if (isset($_SESSION['nama'])): ?>
        <span class="text-white font-semibold">Halo, <?= htmlspecialchars($_SESSION['nama']) ?></span>
        <a href="../index.php" class="bg-red-500 text-black px-3 py-1 rounded">Home</a>
      <?php else: ?>
        <a href="masuk.html" class="bg-yellow-500 text-black px-3 py-1 rounded">Masuk</a>
        <a href="daftar.html" class="bg-gray-700 px-3 py-1 rounded border border-yellow-500">Daftar</a>
      <?php endif; ?>
    </div>
  </nav>

  <div class="container mx-auto p-5">
    <h1 class="text-2xl font-bold mb-6">Pilih Game</h1>
    
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-3 gap-6">
      <!-- Mobile Legends -->
      <a href="topup-form.php?game_type=ml" class="game-card">
        <img src="img/games/ml.jpg" alt="Mobile Legends" class="game-img">
        <div class="p-4">
          <h3 class="text-lg font-bold">Mobile Legends</h3>
          <p class="text-sm text-gray-300">Moonton</p>
          <div class="mt-2 bg-blue-900 inline-block px-2 py-1 rounded text-xs">Terpopuler</div>
        </div>
      </a>
      
      <!-- Valorant -->
      <a href="topup-form.php?game_type=valorant" class="game-card">
        <img src="img/games/valorant.jpg" alt="Valorant" class="game-img">
        <div class="p-4">
          <h3 class="text-lg font-bold">Valorant</h3>
          <p class="text-sm text-gray-300">Riot Games</p>
          <div class="mt-2 bg-blue-900 inline-block px-2 py-1 rounded text-xs">PC Game</div>
        </div>
      </a>
      
      <!-- PUBG Mobile -->
      <a href="topup-form.php?game_type=pubg" class="game-card">
        <img src="img/games/pubg.jpg" alt="PUBG Mobile" class="game-img">
        <div class="p-4">
          <h3 class="text-lg font-bold">PUBG Mobile</h3>
          <p class="text-sm text-gray-300">Tencent</p>
          <div class="mt-2 bg-blue-900 inline-block px-2 py-1 rounded text-xs">Populer</div>
        </div>
      </a>
      
      <!-- Free Fire -->
      <a href="topup-form.php?game_type=ff" class="game-card">
        <img src="img/games/ff.jpg" alt="Free Fire" class="game-img">
        <div class="p-4">
          <h3 class="text-lg font-bold">Free Fire</h3>
          <p class="text-sm text-gray-300">Garena</p>
          <div class="mt-2 bg-blue-900 inline-block px-2 py-1 rounded text-xs">Populer</div>
        </div>
      </a>
      
      <!-- Honor Of Kings -->
      <a href="topup-form.php?game_type=honor" class="game-card">
        <img src="img/games/honor.jpg" alt="Honor Of Kings" class="game-img">
        <div class="p-4">
          <h3 class="text-lg font-bold">Honor Of Kings</h3>
          <p class="text-sm text-gray-300">Tencent Games</p>
          <div class="mt-2 bg-blue-900 inline-block px-2 py-1 rounded text-xs">Baru</div>
        </div>
      </a>
      
      <!-- Genshin Impact -->
      <a href="topup-form.php?game_type=genshin" class="game-card">
        <img src="img/games/genshin.jpg" alt="Genshin Impact" class="game-img">
        <div class="p-4">
          <h3 class="text-lg font-bold">Genshin Impact</h3>
          <p class="text-sm text-gray-300">Hoyoverse</p>
          <div class="mt-2 bg-blue-900 inline-block px-2 py-1 rounded text-xs">Populer</div>
        </div>
      </a>
    </div>
  </div>

  <div class="footer-bottom">© 2024 KMGSTORE. All Rights Reserved.</div>

</body>
</html>
