<?php
session_start();


if (!isset($_SESSION['login_attempts'])) {
    $_SESSION['login_attempts'] = 0;
    $_SESSION['last_attempt_time'] = 0;
}

// Check if user is locked out (5 attempts = 15 minutes lockout)
if ($_SESSION['login_attempts'] >= 5) {
    $lockout_time = 15 * 60; // 15 minutes
    if (time() - $_SESSION['last_attempt_time'] < $lockout_time) {
        $remaining_time = $lockout_time - (time() - $_SESSION['last_attempt_time']);
        $error_message = "Terlalu banyak percobaan login. Coba lagi dalam " . ceil($remaining_time / 60) . " menit.";
    } else {
        // Reset attempts after lockout period
        $_SESSION['login_attempts'] = 0;
        unset($_SESSION['last_attempt_time']);
    }
}

// CSRF Token generation
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Process login only if not locked out
if ($_SERVER["REQUEST_METHOD"] == "POST" && !isset($error_message)) {
    
    // Verify CSRF token
    if (!isset($_POST['csrf_token']) || !hash_equals($_SESSION['csrf_token'], $_POST['csrf_token'])) {
        $error_message = "Token keamanan tidak valid. Silakan refresh halaman.";
    } else {
        // Validate input
        if (empty($_POST['user']) || empty($_POST['password'])) {
            $error_message = "Email/HP dan Password harus diisi!";
            $_SESSION['login_attempts']++;
            $_SESSION['last_attempt_time'] = time();
        } else {
            // Include config file
            if (!file_exists('config.php')) {
                error_log("Config file not found!");
                $error_message = "Terjadi kesalahan sistem. Silakan coba lagi.";
            } else {
                include 'config.php';
                
                // Check database connection
                if (!$conn) {
                    error_log("Database connection failed: " . mysqli_connect_error());
                    $error_message = "Terjadi kesalahan koneksi. Silakan coba lagi.";
                } else {
                    $emailOrHp = trim($_POST['user']);
                    $password = $_POST['password'];
                    
                    // Additional input validation
                    if (strlen($emailOrHp) > 100 || strlen($password) > 255) {
                        $error_message = "Input terlalu panjang!";
                        $_SESSION['login_attempts']++;
                        $_SESSION['last_attempt_time'] = time();
                    } else {
                        // Use prepared statement
                        $query = "SELECT id, nama, email, nohp, password, role FROM users WHERE email = ? OR nohp = ?";
                        $stmt = mysqli_prepare($conn, $query);
                        
                        if ($stmt) {
                            mysqli_stmt_bind_param($stmt, "ss", $emailOrHp, $emailOrHp);
                            mysqli_stmt_execute($stmt);
                            $result = mysqli_stmt_get_result($stmt);
                            
                            if ($result && mysqli_num_rows($result) === 1) {
                                $user = mysqli_fetch_assoc($result);
                                
                                // Verify password
                                if (password_verify($password, $user['password'])) {
                                    // Reset login attempts on successful login
                                    $_SESSION['login_attempts'] = 0;
                                    unset($_SESSION['last_attempt_time']);
                                    
                                    // Set session variables
                                    $_SESSION['user_id'] = $user['id'];
                                    $_SESSION['nama'] = $user['nama'];
                                    $_SESSION['email'] = $user['email'];
                                    $_SESSION['nohp'] = $user['nohp'];
                                    $_SESSION['role'] = $user['role'];
                                    $_SESSION['login_time'] = time();
                                    
                                    // Update last login time
                                    $updateQuery = "UPDATE users SET last_login = NOW() WHERE id = ?";
                                    $updateStmt = mysqli_prepare($conn, $updateQuery);
                                    if ($updateStmt) {
                                        mysqli_stmt_bind_param($updateStmt, "i", $user['id']);
                                        mysqli_stmt_execute($updateStmt);
                                        mysqli_stmt_close($updateStmt);
                                    }
                                    
                                    // Generate new CSRF token
                                    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
                                    
                                    // Redirect based on role
                                    if ($user['role'] === 'admin') {
                                        header("Location: ../admin/dashboard.php");
                                    } else {
                                        header("Location: ../index.php");
                                    }
                                    exit();
                                } else {
                                    $error_message = "Email/Password salah!";
                                    $_SESSION['login_attempts']++;
                                    $_SESSION['last_attempt_time'] = time();
                                }
                            } else {
                                $error_message = "Email/Password salah!";
                                $_SESSION['login_attempts']++;
                                $_SESSION['last_attempt_time'] = time();
                            }
                            
                            mysqli_stmt_close($stmt);
                        } else {
                            error_log("Database prepare failed: " . mysqli_error($conn));
                            $error_message = "Terjadi kesalahan sistem. Silakan coba lagi.";
                        }
                        
                        mysqli_close($conn);
                    }
                }
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Masuk - KMGSTORE | Top Up Games Termurah & Tercepat</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <style>
        @import url("https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap");

        body {
            font-family: "Poppins", sans-serif;
            background-color: #0f172a;
            background-image: radial-gradient(circle at 25% 25%, rgba(66, 26, 91, 0.2) 0%, transparent 40%),
                radial-gradient(circle at 75% 75%, rgba(25, 84, 123, 0.2) 0%, transparent 40%);
            background-attachment: fixed;
        }

        .gradient-border {
            position: relative;
            border-radius: 0.75rem;
            z-index: 0;
            overflow: hidden;
        }

        .gradient-border::before {
            content: "";
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: linear-gradient(45deg, #ff8a00, #dd356e, #8a49ff, #3b82f6);
            z-index: -1;
            animation: borderAnimation 8s linear infinite;
            border-radius: 0.85rem;
        }

        @keyframes borderAnimation {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .glow-btn {
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .glow-btn:hover {
            box-shadow: 0 0 15px rgba(255, 204, 0, 0.6);
        }

        .login-card {
            transition: all 0.3s ease;
            transform: translateY(0);
        }

        .login-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
        }

        .input-group {
            position: relative;
            margin-bottom: 1.5rem;
        }

        .input-group input {
            width: 100%;
            padding: 0.75rem 1rem;
            padding-left: 2.5rem;
            border-radius: 0.5rem;
            background-color: rgba(31, 41, 55, 0.8);
            color: white;
            border: 1px solid rgba(75, 85, 99, 0.5);
            transition: all 0.3s ease;
        }

        .input-group input:focus {
            outline: none;
            border-color: #fbbf24;
            box-shadow: 0 0 0 2px rgba(251, 191, 36, 0.3);
        }

        .input-group i {
            position: absolute;
            left: 0.75rem;
            top: 0.85rem;
            color: #9ca3af;
            transition: all 0.3s ease;
        }

        .input-group input:focus + i {
            color: #fbbf24;
        }

        .error-alert {
            background-color: #fef2f2;
            border: 1px solid #fecaca;
            color: #dc2626;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            display: flex;
            align-items: center;
        }

        .error-alert i {
            margin-right: 8px;
        }

        .hero-section {
            background-image: url("img/hero-bg.jpg");
            background-size: cover;
            background-position: center;
            position: relative;
        }

        .hero-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(to bottom, rgba(15, 23, 42, 0.7), rgba(15, 23, 42, 0.9));
        }
    </style>
</head>

<body class="text-white">
    <!-- Navbar -->
    <nav class="bg-gray-800 bg-opacity-80 backdrop-filter backdrop-blur-md sticky top-0 z-50 p-4 flex justify-between items-center shadow-lg">
        <div class="flex items-center space-x-3">
            <div class="relative animate__animated animate__pulse animate__infinite">
                <img src="../img/logo-tokioiboy.jpg" alt="Logo Tokiboy Store" class="h-10 w-10 rounded-full border-2 border-yellow-500" />
                <div class="absolute -top-1 -right-1 h-3 w-3 bg-green-500 rounded-full"></div>
            </div>
            <div>
                <span class="text-xl font-bold bg-gradient-to-r from-yellow-400 via-yellow-300 to-yellow-500 text-transparent bg-clip-text">KMGSTORE</span>
                <p class="text-xs text-gray-400">Top Up Termurah & Tercepat</p>
            </div>
        </div>
        <div class="space-x-2 flex items-center">
            <a href="../index.php" class="glow-btn bg-transparent border border-yellow-500 hover:bg-yellow-500 hover:text-black text-yellow-500 font-bold py-2 px-4 rounded-full flex items-center transition-colors">
                <i class="fas fa-home mr-1"></i> Beranda
            </a>
            <a href="daftar.php" class="glow-btn bg-blue-500 hover:bg-blue-400 text-white font-bold py-2 px-4 rounded-full flex items-center">
                <i class="fas fa-user-plus mr-1"></i> Daftar
            </a>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section py-16 relative mb-8">
        <div class="hero-overlay"></div>
        <div class="container mx-auto px-4 relative z-10">
            <div class="max-w-xl mx-auto text-center">
                <h1 class="text-4xl font-bold mb-4 animate__animated animate__fadeInDown">
                    <span class="bg-gradient-to-r from-yellow-400 via-yellow-300 to-yellow-500 text-transparent bg-clip-text">Masuk ke KMGSTORE</span>
                </h1>
                <p class="text-lg mb-6 text-gray-300 animate__animated animate__fadeInUp">
                    Akses akun Anda untuk mulai top up games favorit dengan harga termurah!
                </p>
            </div>
        </div>
    </section>

    <!-- Login Form Section -->
    <section class="mb-12 px-4">
        <div class="container mx-auto max-w-md">
            <div class="login-card gradient-border bg-gray-800 bg-opacity-70 backdrop-filter backdrop-blur-sm rounded-xl overflow-hidden p-8 shadow-xl">
                <div class="text-center mb-6">
                    <div class="inline-block rounded-full p-3 bg-yellow-500 bg-opacity-20 mb-4">
                        <i class="fas fa-user-shield text-yellow-500 text-3xl"></i>
                    </div>
                    <h2 class="text-2xl font-bold">Login Akun</h2>
                    <p class="text-gray-400 text-sm mt-1">Masukkan kredensial Anda untuk melanjutkan</p>
                </div>

                <?php if (isset($error_message)): ?>
                    <div class="error-alert">
                        <i class="fas fa-exclamation-triangle"></i>
                        <span><?php echo htmlspecialchars($error_message); ?></span>
                    </div>
                <?php endif; ?>

                <form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="POST" id="loginForm">
                    <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
                    
                    <div class="input-group">
                        <input type="text" id="email" name="user" placeholder="Email atau Nomor HP" required autocomplete="username" maxlength="100" />
                        <i class="fas fa-user"></i>
                    </div>

                    <div class="input-group">
                        <input type="password" id="password" name="password" placeholder="Kata Sandi" required autocomplete="current-password" maxlength="255" />
                        <i class="fas fa-lock"></i>
                    </div>

                    <div class="flex justify-between items-center mb-6">
                        <div class="flex items-center">
                            <input type="checkbox" id="remember" class="h-4 w-4 rounded border-gray-600 focus:ring-yellow-500" />
                            <label for="remember" class="ml-2 text-sm text-gray-400">Ingat Saya</label>
                        </div>
                    </div>

                    <button type="submit" class="w-full glow-btn bg-yellow-500 hover:bg-yellow-400 text-black font-bold py-3 px-4 rounded-lg transition">
                        <i class="fas fa-sign-in-alt mr-2"></i> Masuk
                    </button>
                </form>

                <div class="mt-6 text-center">
                    <p class="text-gray-400">
                        Belum punya akun? <a href="daftar.php" class="text-yellow-500 hover:underline font-medium">Daftar Sekarang</a>
                    </p>
                </div>

                <div class="mt-8 pt-6 border-t border-gray-700">
                    <p class="text-center text-xs text-gray-500">
                        Login Sebagai Admin? <a href="../admin.html" class="text-yellow-500 hover:underline">Klik di sini</a>
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="mb-16 px-4">
        <div class="container mx-auto max-w-4xl">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="bg-gray-800 bg-opacity-60 p-6 rounded-xl text-center">
                    <div class="bg-blue-500 bg-opacity-20 h-16 w-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-shield-alt text-blue-400 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold mb-2">Keamanan Terjamin</h3>
                    <p class="text-gray-400 text-sm">Data Anda terenkripsi dan selalu terjaga keamanannya dengan sistem keamanan terbaru.</p>
                </div>
                <div class="bg-gray-800 bg-opacity-60 p-6 rounded-xl text-center">
                    <div class="bg-green-500 bg-opacity-20 h-16 w-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-bolt text-green-400 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold mb-2">Proses Instan</h3>
                    <p class="text-gray-400 text-sm">Top up game langsung diproses dalam hitungan detik setelah pembayaran berhasil.</p>
                </div>
                <div class="bg-gray-800 bg-opacity-60 p-6 rounded-xl text-center">
                    <div class="bg-yellow-500 bg-opacity-20 h-16 w-16 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-headset text-yellow-400 text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold mb-2">24/7 Support</h3>
                    <p class="text-gray-400 text-sm">Tim dukungan kami siap membantu Anda selama 24 jam penuh, 7 hari seminggu.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Loader -->
    <div id="loader" class="fixed inset-0 bg-black bg-opacity-90 flex items-center justify-center hidden z-50">
        <div class="text-center">
            <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-b-4 border-yellow-500 mx-auto mb-4"></div>
            <div class="text-white text-xl font-bold">Loading...</div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const loginForm = document.getElementById("loginForm");
            const submitBtn = loginForm.querySelector('button[type="submit"]');
            
            // Form validation
            loginForm.addEventListener("submit", function (e) {
                let isValid = true;
                const requiredFields = loginForm.querySelectorAll("[required]");

                requiredFields.forEach((field) => {
                    if (!field.value.trim()) {
                        isValid = false;
                        field.classList.add("border-red-500");
                    } else {
                        field.classList.remove("border-red-500");
                    }
                });

                if (isValid) {
                    // Disable submit button and show loading
                    submitBtn.disabled = true;
                    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Memproses...';
                    document.getElementById("loader").classList.remove("hidden");
                }
            });

            // Auto-focus first input
            document.getElementById("email").focus();
        });
    </script>
</body>
</html>