<?php
session_start();
include_once("config.php");

if (!isset($_SESSION['user_id'])) {
    header("Location: masuk.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id        = $_SESSION['user_id'];
    $userid_game    = $_POST['userid'];
    $zoneid_game    = $_POST['zoneid'];
    $nama_game      = $_POST['game'];
    $item_jenis     = $_POST['item_jenis'];
    $item_jumlah    = $_POST['item_jumlah'];
    $nominal        = $_POST['nominal'];
    $metode         = $_POST['metode'];
    $whatsapp       = $_POST['whatsapp'];
    $status         = 'pending';
    $kode_transaksi = 'KMG' . time(); // Atau tambah uniqid() jika perlu
    $created_at     = date('Y-m-d H:i:s');

    // Gunakan prepared statement
    $query = "INSERT INTO transaksi (
                kode_transaksi, user_id, userid_game, zoneid_game, nama_game, item_jenis, item_jumlah,
                nominal, metode_pembayaran, whatsapp, status, created_at
              )
              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = mysqli_prepare($conn, $query);
    if ($stmt) {
        mysqli_stmt_bind_param(
            $stmt, "sissssisssss",
            $kode_transaksi, $user_id, $userid_game, $zoneid_game, $nama_game, $item_jenis,
            $item_jumlah, $nominal, $metode, $whatsapp, $status, $created_at
        );

        $_SESSION['transaksi'] = [
        'kode_transaksi' => $kode_transaksi,
        'game'           => $nama_game,
        'item_jenis'     => $item_jenis,
        'item_jumlah'    => $item_jumlah,
        'nominal'        => $nominal,
        'metode'         => $metode,
        'userid'         => $userid_game,
        'zoneid'         => $zoneid_game,
        'whatsapp'       => $whatsapp,
        'created_at'     => $created_at,
        'status'         => $status
        ];

        

        if (mysqli_stmt_execute($stmt)) {
            mysqli_stmt_close($stmt);
            echo "<script>alert('Transaksi berhasil dikirim!'); window.location.href='struck-pembayaran..php';</script>";
        } else {
            echo "<script>alert('Gagal menyimpan transaksi.'); window.history.back();</script>";
        }
    } else {
        echo "<script>alert('Query gagal disiapkan.'); window.history.back();</script>";
    }
}
?>
