<?php
// File: topup-form.php
// Form untuk mengisi data top-up dan meneruskan ke halaman konfirmasi pembayaran

session_start();
include_once("config.php");
include_once("functions.php");

cek_login_user();

// Ambil tipe game dari URL parameter
$game_type = isset($_GET['game_type']) ? htmlspecialchars($_GET['game_type']) : 'ml';

// Mapping nama game
$game_names = [
    'ml' => 'Mobile Legends',
    'pubg' => 'PUBG Mobile',
    'genshin' => 'Genshin Impact',
    'honor' => 'Honor of Kings',
    'valorant' => 'Valorant',
    'ff' => 'Free Fire'
];

// Ambil nama game berdasarkan tipe
$game_name = isset($game_names[$game_type]) ? $game_names[$game_type] : 'Mobile Legends';

// Mapping mata uang game
$game_currency = [
    'ml' => 'Diamond',
    'pubg' => 'UC',
    'genshin' => 'Genesis Crystal',
    'honor' => 'Voucher',
    'valorant' => 'Valorant Points',
    'ff' => 'Diamond'
];

// Ambil jenis mata uang game
$currency = isset($game_currency[$game_type]) ? $game_currency[$game_type] : 'Item';

// Perbaikan mapping gambar game dengan fallback
$game_images = [
    'ml' => '../img/mobilelegend.jpg',  
    'pubg' => '../img/pubg640.jpg',
    'genshin' => '../img/genshinimpact.jpg',
    'honor' => '../img/honornihboss.jpg',
    'valorant' => '../img/valorantt.jpg',
    'ff' => '../img/gametiles_com.dts.freefireth.jpg'
];

// Fungsi untuk mengecek apakah file gambar ada
function getGameImage($game_type, $game_images) {
    $default_image = '../img/default-game.jpg';
    
    if (isset($game_images[$game_type])) {
        $image_path = $game_images[$game_type];
        // Cek apakah file ada di server
        if (file_exists($image_path)) {
            return $image_path;
        }
    }
    
    // Jika file tidak ada, coba dengan nama alternatif
    $alternative_names = [
        'ml' => ['mobile-legends.png', 'ml.jpg', 'ml.png', 'mobilelegends.jpg'],
        'pubg' => ['pubg.png', 'pubg-mobile.jpg', 'pubgmobile.jpg'],
        'genshin' => ['genshin.png', 'genshin-impact.jpg', 'genshinimpact.jpg'],
        'honor' => ['honor.png', 'honor-of-kings.jpg', 'hok.jpg'],
        'valorant' => ['valorant.png', 'val.jpg'],
        'ff' => ['free-fire.png', 'freefire.jpg', 'ff.jpg']
    ];
    
    if (isset($alternative_names[$game_type])) {
        foreach ($alternative_names[$game_type] as $alt_name) {
            $alt_path = '../img/' . $alt_name;
            if (file_exists($alt_path)) {
                return $alt_path;
            }
        }
    }
    
    // Jika masih tidak ada, gunakan default atau placeholder
    return file_exists($default_image) ? $default_image : 'data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMTIwIiBoZWlnaHQ9IjEyMCIgdmlld0JveD0iMCAwIDEyMCAxMjAiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CjxyZWN0IHdpZHRoPSIxMjAiIGhlaWdodD0iMTIwIiBmaWxsPSIjMzMzIi8+Cjx0ZXh0IHg9IjYwIiB5PSI2MCIgZmlsbD0iI2ZmZiIgdGV4dC1hbmNob3I9Im1pZGRsZSIgZHk9Ii4zZW0iIGZvbnQtZmFtaWx5PSJBcmlhbCIgZm9udC1zaXplPSIxNCIgZm9udC13ZWlnaHQ9ImJvbGQiPkdBTUU8L3RleHQ+Cjwvc3ZnPg==';
}

$game_image = getGameImage($game_type, $game_images);

// Query untuk mengambil data produk berdasarkan game type
$nominal_options = [];
$debug_info = [];

try {
    // Debug: Tampilkan struktur tabel
    $debug_query = "SHOW COLUMNS FROM produk";
    $debug_result = $conn->query($debug_query);
    if ($debug_result) {
        while ($row = $debug_result->fetch_assoc()) {
            $debug_info['columns'][] = $row;
        }
    }
    
    // Debug: Tampilkan semua data produk untuk melihat isi tabel
    $debug_query2 = "SELECT * FROM produk LIMIT 5";
    $debug_result2 = $conn->query($debug_query2);
    if ($debug_result2) {
        while ($row = $debug_result2->fetch_assoc()) {
            $debug_info['sample_data'][] = $row;
        }
    }
    
    // Coba berbagai kemungkinan nama kolom dan nilai
    $possible_queries = [
        // Kemungkinan 1: Menggunakan nama_game dengan nama lengkap
        [
            'query' => "SELECT product_nominal, product_total_bayar FROM produk WHERE nama_game = ? ORDER BY product_total_bayar ASC",
            'param' => $game_name
        ],
        // Kemungkinan 2: Menggunakan product_nama_game dengan nama lengkap
        [
            'query' => "SELECT product_nominal, product_total_bayar FROM produk WHERE product_nama_game = ? ORDER BY product_total_bayar ASC",
            'param' => $game_name
        ],
        // Kemungkinan 3: Menggunakan nama_game dengan kode game
        [
            'query' => "SELECT product_nominal, product_total_bayar FROM produk WHERE nama_game = ? ORDER BY product_total_bayar ASC",
            'param' => $game_type
        ],
        // Kemungkinan 4: Menggunakan product_nama_game dengan kode game
        [
            'query' => "SELECT product_nominal, product_total_bayar FROM produk WHERE product_nama_game = ? ORDER BY product_total_bayar ASC",
            'param' => $game_type
        ],
        // Kemungkinan 5: Menggunakan kolom game_name
        [
            'query' => "SELECT product_nominal, product_total_bayar FROM produk WHERE game_name = ? ORDER BY product_total_bayar ASC",
            'param' => $game_name
        ],
        // Kemungkinan 6: Menggunakan LIKE untuk pencarian partial
        [
            'query' => "SELECT product_nominal, product_total_bayar FROM produk WHERE nama_game LIKE ? ORDER BY product_total_bayar ASC",
            'param' => "%{$game_name}%"
        ]
    ];
    
    // Coba setiap query sampai ada yang berhasil
    foreach ($possible_queries as $query_info) {
        $stmt = $conn->prepare($query_info['query']);
        if ($stmt) {
            $stmt->bind_param("s", $query_info['param']);
            $stmt->execute();
            $result = $stmt->get_result();
            
            if ($result && $result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $nominal_options[] = [
                        'label' => $row['product_nominal'],
                        'price' => (int)$row['product_total_bayar']
                    ];
                }
                $stmt->close();
                $debug_info['successful_query'] = $query_info;
                break; // Keluar dari loop jika berhasil
            }
            $stmt->close();
        }
    }
    
    // Jika masih belum berhasil, coba query tanpa WHERE untuk melihat semua data
    if (empty($nominal_options)) {
        $fallback_query = "SELECT product_nominal, product_total_bayar, nama_game, product_nama_game FROM produk ORDER BY product_total_bayar ASC";
        $fallback_result = $conn->query($fallback_query);
        if ($fallback_result) {
            while ($row = $fallback_result->fetch_assoc()) {
                $debug_info['all_products'][] = $row;
                
                // Coba cocokkan dengan berbagai cara
                $row_game_name = isset($row['nama_game']) ? $row['nama_game'] : (isset($row['product_nama_game']) ? $row['product_nama_game'] : '');
                
                if (
                    strtolower($row_game_name) === strtolower($game_name) ||
                    strtolower($row_game_name) === strtolower($game_type) ||
                    strpos(strtolower($row_game_name), strtolower('mobile legends')) !== false && $game_type === 'ml'
                ) {
                    $nominal_options[] = [
                        'label' => $row['product_nominal'],
                        'price' => (int)$row['product_total_bayar']
                    ];
                }
            }
        }
    }
    
} catch (Exception $e) {
    error_log("Error mengambil data produk: " . $e->getMessage());
    $debug_info['error'] = $e->getMessage();
    $nominal_options = [];
}

// Jika tidak ada data produk untuk game type tersebut
if (empty($nominal_options)) {
    // Set default products atau redirect
    $nominal_options = [
        ['label' => 'Produk tidak tersedia', 'price' => 0]
    ];
}

// Tampilkan debug info jika dalam mode development
$show_debug = isset($_GET['debug']) && $_GET['debug'] == '1';

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>KMGSTORE - <?= $game_name ?> Top Up</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #ffa500;
            --secondary-color: #1a1f2e;
            --text-color: #ffffff;
            --accent-color: #ff4c4c;
            --input-bg: #272e40;
            --card-bg: #1e2635;
        }
        
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #141824;
            color: var(--text-color);
            position: relative;
        }
        
        .top-bar {
            background-color: #ff9800;
            padding: 3px 0;
            width: 100%;
        }

        .navbar {
            background-color: var(--card-bg);
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
        }
        
        .logo {
            font-size: 22px;
            font-weight: bold;
            color: #ffa500;
            text-decoration: none;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .section {
            background-color: var(--card-bg);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .section-header {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .section-number {
            background-color: #ffa500;
            color: var(--secondary-color);
            width: 30px;
            height: 30px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-right: 10px;
        }
        
        .form-input {
            width: 100%;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid #3a3f4b;
            background-color: var(--input-bg);
            color: #fff;
            margin-bottom: 12px;
        }
        
        .form-input::placeholder {
            color: #8e93a3;
        }
        
        .info-text {
            font-size: 12px;
            color: #8e93a3;
            margin-top: 10px;
            line-height: 1.5;
        }
        
        .diamond-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 12px;
            margin-top: 15px;
        }
        
        .diamond-card {
            background-color: #272e40;
            border-radius: 8px;
            padding: 15px;
            text-align: center;
            cursor: pointer;
            transition: all 0.2s;
            border: 2px solid transparent;
        }
        
        .diamond-card:hover {
            background-color: #313a51;
        }
        
        .diamond-card.selected {
            border-color: #ffa500;
        }
        
        .diamond-card.disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }
        
        .diamond-amount {
            font-weight: bold;
            font-size: 16px;
            margin-bottom: 5px;
        }
        
        .diamond-price {
            color: #b7bac7;
            font-size: 14px;
        }
        
        .payment-method {
            display: flex;
            align-items: center;
            padding: 15px;
            border-radius: 8px;
            background-color: #272e40;
            margin-bottom: 12px;
            cursor: pointer;
            border: 2px solid transparent;
        }
        
        .payment-method:hover {
            background-color: #313a51;
        }
        
        .payment-method.selected {
            border-color: #ffa500;
        }
        
        .payment-logo {
            width: 40px;
            height: 40px;
            margin-right: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .payment-logo img {
            max-width: 100%;
            max-height: 100%;
        }
        
        .payment-label {
            font-size: 16px;
        }
        
        .whatsapp-input {
            margin-top: 20px;
        }
        
        .submit-button {
            background-color: #ffa500;
            color: #1a1f2e;
            border: none;
            border-radius: 8px;
            padding: 15px;
            font-size: 16px;
            font-weight: bold;
            width: 100%;
            cursor: pointer;
            margin-top: 20px;
            transition: background 0.2s;
        }
        
        .submit-button:hover {
            background-color: #ffb733;
        }
        
        .submit-button:disabled {
            background-color: #666;
            cursor: not-allowed;
        }
        
        .footer {
            background-color: var(--card-bg);
            padding: 20px 0;
            text-align: center;
            margin-top: 40px;
            font-size: 14px;
            color: #8e93a3;
        }
        
        /* Game page specific styles */
        .game-info-container {
            display: flex;
            align-items: center;
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .game-image {
            width: 120px;
            height: 120px;
            border-radius: 12px;
            overflow: hidden;
            border: 3px solid #ffa500;
            background-color: #272e40;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }
        
        .game-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: opacity 0.3s;
        }
        
        .game-image .placeholder {
            display: none;
            color: #8e93a3;
            font-size: 12px;
            text-align: center;
            line-height: 1.2;
        }
        
        .game-image.no-image .placeholder {
            display: block;
        }
        
        .game-image.no-image img {
            opacity: 0;
        }
        
        .game-details h1 {
            font-size: 24px;
            margin-bottom: 10px;
        }
        
        .game-details p {
            color: #ccc;
            font-size: 14px;
        }
        
        /* Floating WhatsApp button */
        .whatsapp-float {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background-color: #25D366;
            color: white;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
            z-index: 1000;
            font-size: 32px;
        }
        
        .no-products {
            text-align: center;
            padding: 40px;
            color: #8e93a3;
        }
        
        .loading {
            display: none;
            text-align: center;
            padding: 20px;
            color: #8e93a3;
        }
        
        .error-message {
            background-color: #ff4c4c;
            color: white;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 15px;
            display: none;
        }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="bg-gray-800 bg-opacity-80 backdrop-filter backdrop-blur-md sticky top-0 z-50 p-4 flex justify-between items-center shadow-lg">
        <!-- Kiri: Logo -->
        <div class="flex items-center space-x-3">
            <div class="relative">
                <img src="../img/logo-tokioiboy.jpg" alt="Logo Tokiboy Store" class="h-10 w-10 rounded-full border-2 border-yellow-500" />
                <div class="absolute -top-1 -right-1 h-3 w-3 bg-green-500 rounded-full"></div>
            </div>
            <div>
                <span class="text-xl font-bold bg-gradient-to-r from-yellow-400 via-yellow-300 to-yellow-500 text-transparent bg-clip-text">KMGSTORE</span>
                <p class="text-xs text-gray-400">Top Up Termurah & Tercepat</p>
            </div>
        </div>

        <!-- Kanan: Menu / User -->
        <div class="space-x-2 flex items-center">
            <?php if (isset($_SESSION['nama'])): ?>
                <div class="bg-gray-700 px-3 py-1 rounded-full flex items-center">
                    <i class="fas fa-user-circle mr-2"></i>
                    <span class="text-white">Halo, <?= htmlspecialchars($_SESSION['nama']) ?>!</span>
                </div>
                <a href="../index.php" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-full flex items-center">
                    <i class="fas fa-home mr-1"></i> Home
                </a>
            <?php else: ?>
                <a href="masuk.php" class="bg-yellow-500 text-black px-3 py-1 rounded">Masuk</a>
                <a href="daftar.php" class="bg-gray-700 px-3 py-1 rounded border border-yellow-500">Daftar</a>
            <?php endif; ?>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container">
        <!-- Game Info -->
        <div class="game-info-container">
            <div class="game-image" id="game-image-container">
                <img src="<?= $game_image ?>" alt="<?= $game_name ?>" id="game-image" onerror="handleImageError(this)">
                <div class="placeholder">
                    <i class="fas fa-gamepad" style="font-size: 24px; margin-bottom: 5px;"></i><br>
                    <?= $game_name ?>
                </div>
            </div>
            <div class="game-details">
                <h1><?= $game_name ?></h1>
                <p>Proses Cepat | Layanan 24/7 | Region Indonesia | Pembayaran Aman</p>
            </div>
        </div>
        
        <!-- Cara Top Up -->
        <div class="section">
            <h3 class="font-bold text-lg mb-3">Cara Topup :</h3>
            <ol class="list-decimal ml-5 space-y-2">
                <li>Pastikan User ID Anda <?php if ($game_type === 'ml'): ?>dan Zone ID Anda<?php endif; ?></li>
                <li>Pilih Nominal <?= $currency ?> yang kamu inginkan</li>
                <li>Selesaikan pembayaran</li>
                <li><?= $currency ?> akan ditambahkan ke akun <?= $game_name ?> kamu</li>
                <li>Topup 24 Jam akan tetap diproses</li>
            </ol>
        </div>
        
        <!-- Error Message -->
        <div class="error-message" id="error-message"></div>
        
        <!-- Form untuk top-up -->
        <form action="konfirmasi-pembayaran.php" method="POST" id="payment-form">
            <!-- Hidden field untuk menyimpan tipe game -->
            <input type="hidden" name="game_type" value="<?= $game_type ?>">
            
            <!-- User ID Section -->
            <div class="section">
                <div class="section-header">
                    <div class="section-number">1</div>
                    <h3 class="font-bold">
                        <?php if ($game_type === 'ml'): ?>
                            Masukkan User ID Dan Zone ID
                        <?php else: ?>
                            Masukkan User ID
                        <?php endif; ?>
                    </h3>
                </div>
                
                <input type="text" class="form-input" id="user-id" name="userid" placeholder="Masukkan User ID" required>
                
                <?php if ($game_type === 'ml'): ?>
                <input type="text" class="form-input" id="zone-id" name="zoneid" placeholder="Masukkan Zone ID" required>
                <p class="info-text">
                    Untuk mengetahui User ID Anda, silahkan klik menu profile di bagian kiri atas pada menu utama game.<br>
                    Contoh <strong>12345678(1234)</strong>. Maka ID = 12345678 dan Server = 1234.
                </p>
                <?php endif; ?>
            </div>
            
            <!-- Nominal Section -->
            <div class="section">
                <div class="section-header">
                    <div class="section-number">2</div>
                    <h3 class="font-bold">Pilih Nominal Layanan</h3>
                </div>
                
                <p class="mb-3">Top Up <?= $currency ?></p>
                
                <?php if (empty($nominal_options) || $nominal_options[0]['price'] == 0): ?>
                    <div class="no-products">
                        <i class="fas fa-exclamation-triangle text-4xl mb-4"></i>
                        <p>Produk untuk <?= $game_name ?> sedang tidak tersedia.</p>
                        <p>Silahkan hubungi admin atau coba lagi nanti.</p>
                    </div>
                <?php else: ?>
                    <div class="diamond-grid">
                        <?php foreach ($nominal_options as $index => $option): ?>
                        <div class="diamond-card" data-value="<?= htmlspecialchars($option['label']) ?>" data-price="<?= $option['price'] ?>">
                            <div class="diamond-amount"><?= htmlspecialchars($option['label']) ?></div>
                            <div class="diamond-price">Rp <?= number_format($option['price'], 0, ',', '.') ?></div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                
                <input type="hidden" name="nominal" id="selected-nominal" required>
                <input type="hidden" name="harga" id="selected-price" required>
            </div>
            
            <!-- Payment Methods -->
            <div class="section">
                <div class="section-header">
                    <div class="section-number">3</div>
                    <h3 class="font-bold">Pilih Metode Pembayaran</h3>
                </div>
                
                <p class="mt-3 mb-2 font-semibold">Virtual Account</p>
                
                <div class="payment-method" data-method="mandiri">
                    <div class="payment-logo">
                        <img src="../img/mandiri.webp" alt="MANDIRI" onerror="this.style.display='none'">
                    </div>
                    <div class="payment-label">MANDIRI</div>
                </div>
                
                <div class="payment-method" data-method="bni">
                    <div class="payment-logo">
                        <img src="../img/Logo-Bank-BNI-dark_BG.png" alt="BNI" onerror="this.style.display='none'">
                    </div>
                    <div class="payment-label">BNI</div>
                </div>
                
                <div class="payment-method" data-method="bri">
                    <div class="payment-logo">
                        <img src="../img/briii.png" alt="BRI" onerror="this.style.display='none'">
                    </div>
                    <div class="payment-label">BRI</div>
                </div>
                
                <div class="payment-method" data-method="bca">
                    <div class="payment-logo">
                        <img src="../img/bca.jpg" alt="BCA" onerror="this.style.display='none'">
                    </div>
                    <div class="payment-label">BCA</div>
                </div>
                
                <div class="whatsapp-input">
                    <input type="text" class="form-input" id="whatsapp-number" name="whatsapp" placeholder="Masukkan No. WhatsApp (contoh: 08123456789)" required>
                    <p class="info-text">
                        * Nomor ini akan digunakan untuk konfirmasi jika ada kendala.<br>
                        * Pastikan ID yang Anda masukkan benar! Kesalahan input bukan tanggung jawab kami.
                    </p>
                </div>
                
                <input type="hidden" name="metode" id="selected-payment" required>
                <button type="submit" class="submit-button" id="submit-btn">Bayar Sekarang</button>
            </div>
        </form>
    </div>
    
    
    <!-- Footer -->
    <div class="footer">
        &copy; 2025 KMGSTORE. All Rights Reserved.
    </div>
    
    <!-- WhatsApp Float Button -->
    <a href="https://wa.me/+6285875537316" class="whatsapp-float" target="_blank">
        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="currentColor" viewBox="0 0 16 16">
            <path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"/>
        </svg>
    </a>
    
    <script>
        // Global variables to track selections
        let selectedDiamond = null;
        let selectedPayment = null;
        
        // Function to show error message
        function showError(message) {
            const errorDiv = document.getElementById('error-message');
            errorDiv.textContent = message;
            errorDiv.style.display = 'block';
            
            // Hide error after 5 seconds
            setTimeout(() => {
                errorDiv.style.display = 'none';
            }, 5000);
        }
        
        // Function to validate WhatsApp number
        function validateWhatsApp(number) {
            // Remove all non-digit characters
            const cleanNumber = number.replace(/\D/g, '');
            
            // Check if starts with 0 and has 10-13 digits total
            if (cleanNumber.startsWith('0') && cleanNumber.length >= 10 && cleanNumber.length <= 13) {
                return true;
            }
            
            // Check if starts with 62 and has 11-14 digits total
            if (cleanNumber.startsWith('62') && cleanNumber.length >= 11 && cleanNumber.length <= 14) {
                return true;
            }
            
            return false;
        }
        
        // Event listeners for diamond cards
        document.querySelectorAll('.diamond-card').forEach(card => {
            // Skip if card is disabled (no products)
            if (card.classList.contains('disabled')) {
                return;
            }
            
            card.addEventListener('click', () => {
                // Remove selection from all cards
                document.querySelectorAll('.diamond-card').forEach(c => {
                    c.classList.remove('selected');
                });
                
                // Add selection to clicked card
                card.classList.add('selected');
                
                // Store selected diamond info
                document.getElementById('selected-nominal').value = card.dataset.value;
                document.getElementById('selected-price').value = card.dataset.price;
                
                selectedDiamond = {
                    label: card.dataset.value,
                    price: card.dataset.price
                };
            });
        });
        
        // Event listeners for payment methods
        document.querySelectorAll('.payment-method').forEach(method => {
            method.addEventListener('click', () => {
                // Remove selection from all methods
                document.querySelectorAll('.payment-method').forEach(m => {
                    m.classList.remove('selected');
                });
                
                // Add selection to clicked method
                method.classList.add('selected');
                
                // Store selected payment method
                document.getElementById('selected-payment').value = method.dataset.method;
                
                selectedPayment = method.dataset.method;
            });
        });
        
        // WhatsApp number formatting
        document.getElementById('whatsapp-number').addEventListener('input', function(e) {
            let value = e.target.value;
            
            // Remove all non-digit characters except +
            value = value.replace(/[^\d+]/g, '');
            
            // If starts with +62, keep it
            if (value.startsWith('+62')) {
                e.target.value = value;
            } else if (value.startsWith('62')) {
                e.target.value = '+' + value;
            } else if (value.startsWith('0')) {
                e.target.value = value;
            } else if (value.length > 0) {
                e.target.value = '0' + value;
            }
        });
        
        // Form validation before submission
        document.getElementById('payment-form').addEventListener('submit', function(event) {
            event.preventDefault();
            
            // Get user inputs
            const userId = document.getElementById('user-id').value.trim();
            const selectedNominal = document.getElementById('selected-nominal').value;
            const selectedPayment = document.getElementById('selected-payment').value;
            const whatsapp = document.getElementById('whatsapp-number').value.trim();
            
            // Validate User ID
            if (!userId) {
                showError('Harap masukkan User ID!');
                document.getElementById('user-id').focus();
                return;
            }
            
            // Validate User ID format (basic check)
            if (userId.length < 6) {
                showError('User ID harus minimal 6 karakter!');
                document.getElementById('user-id').focus();
                return;
            }
            
            <?php if ($game_type === 'ml'): ?>
            // Validate Zone ID for Mobile Legends
            const zoneId = document.getElementById('zone-id').value.trim();
            if (!zoneId) {
                showError('Harap masukkan Zone ID!');
                document.getElementById('zone-id').focus();
                return;
            }
            
            if (zoneId.length < 4) {
                showError('Zone ID harus minimal 4 karakter!');
                document.getElementById('zone-id').focus();
                return;
            }
            <?php endif; ?>
            
            // Validate nominal selection
            if (!selectedNominal) {
                showError('Harap pilih nominal <?= $currency ?>!');
                return;
            }
            
            // Validate payment method
            if (!selectedPayment) {
                showError('Harap pilih metode pembayaran!');
                return;
            }
            
            // Validate WhatsApp number
            if (!whatsapp) {
                showError('Harap masukkan nomor WhatsApp!');
                document.getElementById('whatsapp-number').focus();
                return;
            }
            
            if (!validateWhatsApp(whatsapp)) {
                showError('Format nomor WhatsApp tidak valid! Gunakan format: 08123456789 atau +6281234567890');
                document.getElementById('whatsapp-number').focus();
                return;
            }
            
            // Show loading state
            const submitBtn = document.getElementById('submit-btn');
            submitBtn.disabled = true;
            submitBtn.textContent = 'Memproses...';
            
            // Submit the form
            setTimeout(() => {
                this.submit();
            }, 500);
        });
        
        // Check if products are available
        const diamondCards = document.querySelectorAll('.diamond-card');
        if (diamondCards.length === 0 || (diamondCards.length === 1 && diamondCards[0].dataset.price == '0')) {
            document.getElementById('submit-btn').disabled = true;
            document.getElementById('submit-btn').textContent = 'Produk Tidak Tersedia';
        }
        
        // Auto-focus on first input
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('user-id').focus();
        });
    </script>
</body>
</html>