<?php
session_start();
?>

<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>KMGSTORE - Top Up Games Termurah & Tercepat</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
  <link href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css" rel="stylesheet" />
  <link href="style.css" rel="stylesheet" />
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    
    body {
      font-family: 'Poppins', sans-serif;
      background-color: #0f172a;
      background-image: 
        radial-gradient(circle at 25% 25%, rgba(66, 26, 91, 0.2) 0%, transparent 40%),
        radial-gradient(circle at 75% 75%, rgba(25, 84, 123, 0.2) 0%, transparent 40%);
      background-attachment: fixed;
    }
    
    .game-card {
      transition: all 0.3s ease;
    }
    
    .game-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
    }
    
    .gradient-border {
      position: relative;
      border-radius: 0.75rem;
      z-index: 0;
      overflow: hidden;
    }
    
    .gradient-border::before {
      content: "";
      position: absolute;
      top: -2px;
      left: -2px;
      right: -2px;
      bottom: -2px;
      background: linear-gradient(45deg, #FF8A00, #DD356E, #8A49FF, #3B82F6);
      z-index: -1;
      animation: borderAnimation 8s linear infinite;
      border-radius: 0.85rem;
    }
    
    @keyframes borderAnimation {
      0% { background-position: 0% 50%; }
      50% { background-position: 100% 50%; }
      100% { background-position: 0% 50%; }
    }
    
    .swiper-slide img {
      width: 100%;
      height: 100%;
      object-fit: cover;
      border-radius: 1rem;
    }
    
    .news-ticker {
      overflow: hidden;
      white-space: nowrap;
    }
    
    .news-ticker-content {
      display: inline-block;
      animation: ticker 25s linear infinite;
      padding-right: 100%;
    }
    
    @keyframes ticker {
      0% { transform: translateX(100%); }
      100% { transform: translateX(-100%); }
    }
    
    .glow-btn {
      position: relative;
      overflow: hidden;
      transition: all 0.3s ease;
    }
    
    .glow-btn:hover {
      box-shadow: 0 0 15px rgba(255, 204, 0, 0.6);
    }
    
    .glow-btn::after {
      content: "";
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background: rgba(255, 255, 255, 0.2);
      transform: rotate(45deg);
      opacity: 0;
      transition: all 0.5s;
    }
    
    .glow-btn:hover::after {
      opacity: 1;
      transform: rotate(45deg) translateX(100%);
    }
    
    .hero-section {
      background-image: url('img/hero-bg.jpg');
      background-size: cover;
      background-position: center;
      position: relative;
    }
    
    .hero-section::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: linear-gradient(to bottom, rgba(15, 23, 42, 0.5), rgba(15, 23, 42, 0.9));
    }
    
    .badge {
      position: absolute;
      top: -5px;
      right: -5px;
      background: red;
      color: white;
      border-radius: 50%;
      padding: 0.15rem 0.4rem;
      font-size: 0.7rem;
      font-weight: bold;
    }
    
    .promo-tag {
      position: absolute;
      top: 10px;
      left: -5px;
      background: #FF8A00;
      color: white;
      padding: 0.2rem 0.6rem;
      font-size: 0.7rem;
      font-weight: bold;
      border-radius: 0 4px 4px 0;
      box-shadow: 0 2px 4px rgba(0,0,0,0.2);
    }
    
    .promo-tag::before {
      content: "";
      position: absolute;
      left: 0;
      bottom: -5px;
      border-top: 5px solid #B35C00;
      border-left: 5px solid transparent;
    }
  </style>
</head>

<body class="text-white">

<!-- News Ticker -->
<div class="bg-yellow-600 text-black py-1 news-ticker">
  <div class="news-ticker-content">
    <span class="font-semibold">🔥 PROMO MINGGU INI: Diskon 15% untuk semua top-up Mobile Legends! &nbsp;&nbsp;|&nbsp;&nbsp; 💰 Dapatkan bonus Diamond 20% untuk top-up Valorant! &nbsp;&nbsp;|&nbsp;&nbsp; 🎮 Game baru: Honor Of Kings sudah tersedia! &nbsp;&nbsp;|&nbsp;&nbsp; 🚀 Proses Top-Up Super Cepat 1-3 Detik!</span>
  </div>
</div>

<!-- Navbar -->
<nav class="bg-gray-800 bg-opacity-80 backdrop-filter backdrop-blur-md sticky top-0 z-50 p-4 flex justify-between items-center shadow-lg">
  <!-- Logo -->
  <div class="flex items-center space-x-3">
    <div class="relative animate__animated animate__pulse animate__infinite">
      <img src="img/logo-tokioiboy.jpg" alt="Logo Tokiboy Store" class="h-10 w-10 rounded-full border-2 border-yellow-500" />
      <div class="absolute -top-1 -right-1 h-3 w-3 bg-green-500 rounded-full"></div>
    </div>
    <div>
      <span class="text-xl font-bold bg-gradient-to-r from-yellow-400 via-yellow-300 to-yellow-500 text-transparent bg-clip-text">KMGSTORE</span>
      <p class="text-xs text-gray-400">Top Up Termurah & Tercepat</p>
    </div>
  </div>

  <!-- User Menu -->
  <div class="space-x-2 flex items-center">
    <?php if (isset($_SESSION['nama'])): ?>
      <div class="bg-gray-700 px-3 py-1 rounded-full flex items-center">
        <i class="fas fa-user-circle mr-2"></i>
        <span class="text-white">Halo, <?= htmlspecialchars($_SESSION['nama']) ?>!</span>
      </div>
      <a href="backend/cekpesanan.php" class="relative glow-btn bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-full flex items-center">
        <i class="fas fa-clipboard-list mr-1"></i> Pesanan
      </a>
      <a href="backend/logout.php" class="glow-btn bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-full flex items-center">
        <i class="fas fa-sign-out-alt mr-1"></i> Logout
      </a>
    <?php else: ?>
      <a href="backend/masuk.php" class="glow-btn bg-yellow-500 hover:bg-yellow-400 text-black font-bold py-2 px-4 rounded-full flex items-center">
        <i class="fas fa-sign-in-alt mr-1"></i> Masuk
      </a>
      <a href="backend/daftar.php" class="glow-btn bg-blue-500 hover:bg-blue-400 text-white font-bold py-2 px-4 rounded-full flex items-center">
        <i class="fas fa-user-plus mr-1"></i> Daftar
      </a>
    <?php endif; ?>
  </div>
</nav>

<!-- Hero Section -->
<section class="hero-section py-20 relative mb-8">
  <div class="container mx-auto px-4 relative z-10">
    <div class="max-w-2xl mx-auto text-center">
      <h1 class="text-4xl md:text-5xl font-bold mb-4 animate__animated animate__fadeInDown">
        <span class="bg-gradient-to-r from-yellow-400 via-yellow-300 to-yellow-500 text-transparent bg-clip-text">Top Up Games Termurah & Tercepat</span>
      </h1>
      <p class="text-lg mb-8 text-gray-300 animate__animated animate__fadeInUp">Proses cepat 1-3 detik, buka 24 jam, metode pembayaran lengkap. Aman, terpercaya, dan harga terbaik!</p>
      <div class="flex justify-center space-x-4 animate__animated animate__fadeInUp animate__delay-1s">
        <a href="#games" class="glow-btn bg-yellow-500 hover:bg-yellow-400 text-black font-bold py-3 px-6 rounded-full flex items-center">
          <i class="fas fa-gamepad mr-2"></i> Top Up Sekarang
        </a>
        <a href="#promo" class="glow-btn bg-transparent border-2 border-yellow-500 hover:bg-yellow-500 hover:text-black text-yellow-500 font-bold py-3 px-6 rounded-full flex items-center">
          <i class="fas fa-percent mr-2"></i> Lihat Promo
        </a>
      </div>
    </div>
  </div>
</section>

<!-- Hot Games Section -->
<section id="promo" class="px-4 mb-12">
  <div class="container mx-auto">
    <div class="flex justify-between items-center mb-6">
      <h3 class="text-2xl font-bold flex items-center">
        <i class="fas fa-fire text-red-500 mr-2"></i> Promo Terhangat
      </h3>
    </div>
    
    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
      <a href="backend/topup-form.php?game_type=ml" class="game-card bg-gradient-to-b from-gray-800 to-gray-900 rounded-xl overflow-hidden relative">
        <div class="promo-tag">Diskon 15%</div>
        <div class="relative overflow-hidden">
          <img src="img/mobilelegend.jpg" alt="Mobile Legends" class="w-full transition duration-500 transform hover:scale-110" />
          <div class="absolute inset-0 bg-black bg-opacity-20 flex items-center justify-center opacity-0 hover:opacity-100 transition-opacity">
            <span class="bg-yellow-500 text-black font-bold py-1 px-3 rounded-full text-xs">Top Up Sekarang</span>
          </div>
        </div>
        <div class="p-3">
          <div class="flex justify-between items-center mb-1">
            <p class="font-semibold">Mobile Legends</p>
          </div>
          <div class="flex justify-between items-center">
            <p class="text-xs text-gray-400">Moonton</p>
            <p class="text-xs text-green-400">Proses Instan</p>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=valorant" class="game-card bg-gradient-to-b from-gray-800 to-gray-900 rounded-xl overflow-hidden relative">
        <div class="promo-tag">Bonus 20%</div>
        <div class="relative overflow-hidden">
          <img src="img/valorantt.jpg" alt="Valorant" class="w-full transition duration-500 transform hover:scale-110" />
          <div class="absolute inset-0 bg-black bg-opacity-20 flex items-center justify-center opacity-0 hover:opacity-100 transition-opacity">
            <span class="bg-yellow-500 text-black font-bold py-1 px-3 rounded-full text-xs">Top Up Sekarang</span>
          </div>
        </div>
        <div class="p-3">
          <div class="flex justify-between items-center mb-1">
            <p class="font-semibold">Valorant</p>
          </div>
          <div class="flex justify-between items-center">
            <p class="text-xs text-gray-400">Riot Games</p>
            <p class="text-xs text-green-400">Proses Instan</p>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=pubg" class="game-card bg-gradient-to-b from-gray-800 to-gray-900 rounded-xl overflow-hidden relative">
        <div class="promo-tag">Diskon 10%</div>
        <div class="relative overflow-hidden">
          <img src="img/pubg640.jpg" alt="PUBG Mobile" class="w-full transition duration-500 transform hover:scale-110" />
          <div class="absolute inset-0 bg-black bg-opacity-20 flex items-center justify-center opacity-0 hover:opacity-100 transition-opacity">
            <span class="bg-yellow-500 text-black font-bold py-1 px-3 rounded-full text-xs">Top Up Sekarang</span>
          </div>
        </div>
        <div class="p-3">
          <div class="flex justify-between items-center mb-1">
            <p class="font-semibold">PUBG Mobile</p>
          </div>
          <div class="flex justify-between items-center">
            <p class="text-xs text-gray-400">Tencent</p>
            <p class="text-xs text-green-400">Proses Instan</p>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=ff" class="game-card bg-gradient-to-b from-gray-800 to-gray-900 rounded-xl overflow-hidden relative">
        <div class="promo-tag">Cashback 5%</div>
        <div class="relative overflow-hidden">
          <img src="img/gametiles_com.dts.freefireth.jpg" alt="Free Fire" class="w-full transition duration-500 transform hover:scale-110" />
          <div class="absolute inset-0 bg-black bg-opacity-20 flex items-center justify-center opacity-0 hover:opacity-100 transition-opacity">
            <span class="bg-yellow-500 text-black font-bold py-1 px-3 rounded-full text-xs">Top Up Sekarang</span>
          </div>
        </div>
        <div class="p-3">
          <div class="flex justify-between items-center mb-1">
            <p class="font-semibold">Free Fire</p>
          </div>
          <div class="flex justify-between items-center">
            <p class="text-xs text-gray-400">Garena</p>
            <p class="text-xs text-green-400">Proses Instan</p>
          </div>
        </div>
      </a>
    </div>
  </div>
</section>

<!-- Main Games Section -->
<section id="games" class="p-4 mb-12">
  <div class="container mx-auto">
    <div class="flex justify-between items-center mb-6">
      <div>
        <h3 class="text-2xl font-bold">Semua Game</h3>
        <p class="text-gray-400 text-sm">Pilih game favoritmu dan top up sekarang!</p>
      </div>
      <div class="flex space-x-2">
        <button class="bg-yellow-500 text-black px-4 py-1 rounded-full text-sm font-semibold">GAMES</button>
      </div>
    </div>

    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-4">
      <a href="backend/topup-form.php?game_type=ml" class="game-card relative gradient-border">
        <div class="bg-gray-800 p-3 rounded-xl text-center overflow-hidden">
          <div class="mb-2 overflow-hidden rounded-lg">
            <img src="img/mobilelegend.jpg" alt="Mobile Legends" class="w-full transition duration-300 transform hover:scale-110" />
          </div>
          <p class="font-semibold text-sm">Mobile Legends</p>
          <p class="text-xs text-gray-400">Moonton</p>
          <div class="mt-2">
            <span class="inline-block bg-green-900 text-green-300 text-xs px-2 py-1 rounded-full">Terpopuler</span>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=valorant" class="game-card relative">
        <div class="bg-gray-800 p-3 rounded-xl text-center overflow-hidden">
          <div class="mb-2 overflow-hidden rounded-lg">
            <img src="img/valorantt.jpg" alt="Valorant" class="w-full transition duration-300 transform hover:scale-110" />
          </div>
          <p class="font-semibold text-sm">Valorant</p>
          <p class="text-xs text-gray-400">Riot Games</p>
          <div class="mt-2">
            <span class="inline-block bg-blue-900 text-blue-300 text-xs px-2 py-1 rounded-full">PC Game</span>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=pubg" class="game-card relative">
        <div class="bg-gray-800 p-3 rounded-xl text-center overflow-hidden">
          <div class="mb-2 overflow-hidden rounded-lg">
            <img src="img/pubg640.jpg" alt="PUBG Mobile" class="w-full transition duration-300 transform hover:scale-110" />
          </div>
          <p class="font-semibold text-sm">PUBG Mobile</p>
          <p class="text-xs text-gray-400">Tencent</p>
          <div class="mt-2">
            <span class="inline-block bg-gray-700 text-gray-300 text-xs px-2 py-1 rounded-full">Populer</span>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=ff" class="game-card relative">
        <div class="bg-gray-800 p-3 rounded-xl text-center overflow-hidden">
          <div class="mb-2 overflow-hidden rounded-lg">
            <img src="img/gametiles_com.dts.freefireth.jpg" alt="Free Fire" class="w-full transition duration-300 transform hover:scale-110" />
          </div>
          <p class="font-semibold text-sm">Free Fire</p>
          <p class="text-xs text-gray-400">Garena</p>
          <div class="mt-2">
            <span class="inline-block bg-gray-700 text-gray-300 text-xs px-2 py-1 rounded-full">Populer</span>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=honor" class="game-card relative">
        <div class="bg-gray-800 p-3 rounded-xl text-center overflow-hidden">
          <div class="mb-2 overflow-hidden rounded-lg">
            <img src="img/honornihboss.jpg" alt="Honor Of Kings" class="w-full transition duration-300 transform hover:scale-110" />
          </div>
          <p class="font-semibold text-sm">Honor Of Kings</p>
          <p class="text-xs text-gray-400">Tencent Games</p>
          <div class="mt-2">
            <span class="inline-block bg-orange-900 text-orange-300 text-xs px-2 py-1 rounded-full">Baru</span>
          </div>
        </div>
      </a>
      
      <a href="backend/topup-form.php?game_type=genshin" class="game-card relative">
        <div class="bg-gray-800 p-3 rounded-xl text-center overflow-hidden">
          <div class="mb-2 overflow-hidden rounded-lg">
            <img src="img/genshinimpact.jpg" alt="Genshin Impact" class="w-full transition duration-300 transform hover:scale-110" />
          </div>
          <p class="font-semibold text-sm">Genshin Impact</p>
          <p class="text-xs text-gray-400">Hoyoverse</p>
          <div class="mt-2">
            <span class="inline-block bg-purple-900 text-purple-300 text-xs px-2 py-1 rounded-full">Populer</span>
          </div>
        </div>
      </a>
    </div>
  </div>
</section>

<!-- Cara Penggunaan -->
<section class="py-12 px-4 bg-gradient-to-br from-gray-800 to-gray-900 rounded-xl mx-4 mb-12">
  <div class="container mx-auto">
    <div class="text-center mb-10">
      <h3 class="text-2xl font-bold mb-2">Cara Melakukan Top-Up</h3>
      <p class="text-gray-400">Selesaikan top-up hanya dalam 3 langkah mudah!</p>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
      <div class="bg-gray-800 bg-opacity-50 p-6 rounded-xl text-center">
        <div class="bg-yellow-500 text-black h-16 w-16 rounded-full flex items-center justify-center mx-auto mb-4 text-2xl font-bold">1</div>
        <h4 class="text-lg font-bold mb-2">Pilih Game</h4>
        <p class="text-gray-400 text-sm">Pilih game yang ingin kamu top-up dari katalog kami yang lengkap.</p>
      </div>
      
      <div class="bg-gray-800 bg-opacity-50 p-6 rounded-xl text-center">
        <div class="bg-yellow-500 text-black h-16 w-16 rounded-full flex items-center justify-center mx-auto mb-4 text-2xl font-bold">2</div>
        <h4 class="text-lg font-bold mb-2">Isi Informasi</h4>
        <p class="text-gray-400 text-sm">Isi ID game, pilih nominal top-up, dan metode pembayaran yang kamu inginkan.</p>
      </div>
      
      <div class="bg-gray-800 bg-opacity-50 p-6 rounded-xl text-center">
        <div class="bg-yellow-500 text-black h-16 w-16 rounded-full flex items-center justify-center mx-auto mb-4 text-2xl font-bold">3</div>
        <h4 class="text-lg font-bold mb-2">Selesaikan Pembayaran</h4>
        <p class="text-gray-400 text-sm">Bayar sesuai dengan petunjuk dan top-up akan diproses otomatis dalam hitungan detik!</p>
      </div>
    </div>
  </div>
</section>

<!-- Metode Pembayaran -->
<section class="py-8 px-4 mb-12 bg-gray-900">
  <div class="container mx-auto">
    <div class="text-center mb-8">
      <h2 class="text-3xl font-bold mb-3 text-white">Metode Pembayaran</h2>
      <p class="text-gray-400">Beragam pilihan pembayaran untuk kemudahan Anda</p>
    </div>
    
    <div class="bg-gray-800 p-6 rounded-xl shadow-lg">
      <div class="flex flex-wrap justify-center items-center gap-6">
        <div class="bg-white p-3 rounded-lg w-24 h-16 flex items-center justify-center transition-transform hover:scale-105">
          <img src="img/bca.jpg" alt="BCA" class="max-h-full max-w-full object-contain" />
        </div>
        
        <div class="bg-white p-3 rounded-lg w-24 h-16 flex items-center justify-center transition-transform hover:scale-105">
          <img src="img/BRIVA-BRI.jpg" alt="BRIVA BRI" class="max-h-full max-w-full object-contain" />
        </div>
        
        <div class="bg-white p-3 rounded-lg w-24 h-16 flex items-center justify-center transition-transform hover:scale-105">
          <img src="img/mandiri.webp" alt="Mandiri" class="max-h-full max-w-full object-contain" />
        </div>
        
        <div class="bg-white p-3 rounded-lg w-24 h-16 flex items-center justify-center transition-transform hover:scale-105">
          <img src="img/Logo-Bank-BNI-dark_BG.png" alt="BNI" class="max-h-full max-w-full object-contain" />
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Footer -->
<footer class="bg-gray-800 text-white p-6 mt-10">
  <div class="max-w-screen-xl mx-auto">
    <div class="grid md:grid-cols-4 gap-8 mb-8">
      <div>
        <div class="flex items-center mb-4">
          <img src="img/logo-tokioiboy.jpg" alt="Logo Tokiboy Store" class="h-10 w-10 rounded-full mr-2" />
          <div>
            <div class="text-2xl font-bold bg-gradient-to-r from-yellow-400 via-yellow-300 to-yellow-500 text-transparent bg-clip-text">KMGSTORE</div>
            <p class="text-xs text-gray-400">Top Up Games Termurah & Tercepat</p>
          </div>
        </div>
        <p class="text-sm mb-4">KMGSTORE adalah Website Layanan Top-Up Games Termurah, Tercepat dan Terpercaya di Indonesia. Proses cepat 1-3 detik, buka 24 jam, metode pembayaran lengkap.</p>
        <p class="text-sm">Top up Mobile Legends, PUBG Mobile, Free Fire, Valorant, Honor Of Kings, Genshin Impact, dan lainnya hanya di KMGSTORE!</p>
      </div>

      <div>
        <h3 class="font-semibold text-yellow-400 mb-4">PETA SITUS</h3>
        <ul class="text-sm space-y-2">
          <li><a href="index.php" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Beranda</a></li>
          <li><a href="backend/masuk.php" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Masuk</a></li>
          <li><a href="backend/daftar.php" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Daftar</a></li>
        </ul>
      </div>

      <div>
        <h3 class="font-semibold text-yellow-400 mb-4">GAME POPULER</h3>
        <ul class="text-sm space-y-2">
          <li><a href="backend/topup-form.php?game_type=ml" class="hover:text-yellow-400 flex items<li><a href="backend/topup-form.php?game_type=ml" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Mobile Legends</a></li>
          <li><a href="backend/topup-form.php?game_type=pubg" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> PUBG Mobile</a></li>
          <li><a href="backend/topup-form.php?game_type=ff" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Free Fire</a></li>
          <li><a href="backend/topup-form.php?game_type=valorant" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Valorant</a></li>
          <li><a href="backend/topup-form.php?game_type=honor" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Honor Of Kings</a></li>
          <li><a href="backend/topup-form.php?game_type=genshin" class="hover:text-yellow-400 flex items-center"><i class="fas fa-chevron-right text-xs mr-2"></i> Genshin Impact</a></li>
        </ul>
      </div>

      <div>
        <h3 class="font-semibold text-yellow-400 mb-4">HUBUNGI KAMI</h3>
        <div class="text-sm space-y-3">
          <div class="flex items-center">
            <i class="fab fa-whatsapp text-green-500 mr-3"></i>
            <div>
              <p class="font-semibold">WhatsApp</p>
              <p class="text-gray-400">+62 812-3456-7890</p>
            </div>
          </div>
          <div class="flex items-center">
            <i class="fas fa-envelope text-blue-500 mr-3"></i>
            <div>
              <p class="font-semibold">Email</p>
              <p class="text-gray-400">support@kmgstore.com</p>
            </div>
          </div>
          <div class="flex items-center">
            <i class="fas fa-clock text-yellow-500 mr-3"></i>
            <div>
              <p class="font-semibold">Jam Operasional</p>
              <p class="text-gray-400">24/7 Online</p>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="border-t border-gray-700 pt-6">
      <div class="flex flex-col md:flex-row justify-between items-center">
        <div class="text-sm text-gray-400 mb-4 md:mb-0">
          <p>&copy; 2025 KMGSTORE. All rights reserved.</p>
          <p>Website Top Up Games Termurah & Tercepat di Indonesia</p>
        </div>
        <div class="flex space-x-4">
          <a href="#" class="text-gray-400 hover:text-yellow-400 transition-colors">
            <i class="fab fa-facebook-f"></i>
          </a>
          <a href="#" class="text-gray-400 hover:text-yellow-400 transition-colors">
            <i class="fab fa-twitter"></i>
          </a>
          <a href="#" class="text-gray-400 hover:text-yellow-400 transition-colors">
            <i class="fab fa-instagram"></i>
          </a>
          <a href="#" class="text-gray-400 hover:text-yellow-400 transition-colors">
            <i class="fab fa-discord"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</footer>

<!-- Floating WhatsApp Button -->
<div class="fixed bottom-6 right-6 z-50">
  <a href="https://wa.me/6285875537316" target="_blank" class="bg-green-500 hover:bg-green-600 text-white p-4 rounded-full shadow-lg transition-all duration-300 transform hover:scale-110 flex items-center justify-center">
    <i class="fab fa-whatsapp text-2xl"></i>
  </a>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
<script>
  // Smooth scrolling for anchor links
  document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
      e.preventDefault();
      const target = document.querySelector(this.getAttribute('href'));
      if (target) {
        target.scrollIntoView({
          behavior: 'smooth',
          block: 'start'
        });
      }
    });
  });

  // Add loading animation
  window.addEventListener('load', function() {
    document.body.classList.add('loaded');
  });

  // Navbar scroll effect
  window.addEventListener('scroll', function() {
    const navbar = document.querySelector('nav');
    if (window.scrollY > 50) {
      navbar.classList.add('bg-opacity-95');
    } else {
      navbar.classList.remove('bg-opacity-95');
    }
  });
</script>

</body>
</html>